function [radius, intensity, density, mtl] = circularscanline_effectofradius( fractureShp, circleCentre, minRadius, maxRadius, scaleFactor )

if nargin ==4,
    scaleFactor = 1;
end

step = (maxRadius-minRadius)/100;

i = 1;
% Loop increasing the radius each time
for r = minRadius : step: maxRadius,
    
    [n, m] = circularscanline( fractureShp, circleCentre, r);
    
    % scale the radius to that of the real world
    rr = scaleFactor * r;
    
    % Calculate fracture estimators from n and m
    density( i)     = m/(2*pi*(rr^2));
    intensity( i )  = n / (4*rr);
    mtl( i )        = pi*0.5*rr *(n/m);
    
    % increase i the index
    i = i + 1;
end

radius = scaleFactor * (minRadius : step: maxRadius);

figure;
subplot(3,1,1), 
plot(radius, density, '.b'); 
% axis( [0, .5, 0, 100])
title('Density vs Circular scanline radius')
xlabel('Radius')
ylabel('Density')


subplot(3,1,2), 
plot(radius, intensity, '.b'); 
% axis( [0, .5, 0, 50])
title('Intensity vs Circular scanline radius')
xlabel('Radius')
ylabel('Intensity')

subplot(3,1,3), 
plot(radius, mtl, '.b'); 
% axis( [0, .5, 0, 2])
title('Mean Trace Length vs Circular scanline radius')
xlabel('radius')
ylabel('Mean Trace Length')


figure
plot([fractureShp.X], [fractureShp.Y], 'k-'), axis image
hold on

t = 0:0.1*pi:2*pi;
x = circleCentre(1) + minRadius*sin(t);
y = circleCentre(2) + minRadius*cos(t);
plot(x,y, 'r')
x = circleCentre(1) + maxRadius*sin(t);
y = circleCentre(2) + maxRadius*cos(t);
plot(x,y, 'b')

legend( 'minimal radius circular scanline', 'maximal radius circular scanline' )
% legend([ 'density', 'intensity', 'mean trace length'])
